/*
   Setup / repair script for level 9 of the Stairway to Columnstore Indexes;
    for use when you lost the database or made too many changes to follow the next levels.
   After running this script, your database should be in more or less the same state
    as it was after running all demo scripts in levels 1 through 8.

   In the "restore database" statement below, change the path to the location
    where you have stored the Contoso database backup downloaded from Microsoft;
    also change the locations for the data and log files to match your system.

   If you lost your download, you can download a fresh copy of the ContosoDW database
    backup file from https://www.microsoft.com/en-us/download/details.aspx?id=18279
*/

-- First drop the existing database if it exists
USE master;
GO

IF EXISTS (SELECT * FROM sys.databases WHERE name = 'ContosoRetailDW')
BEGIN;
    ALTER DATABASE ContosoRetailDW SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
    DROP DATABASE ContosoRetailDW;
END;

-- Now restore. Don't forget to edit path names in this statement!!
RESTORE DATABASE ContosoRetailDW
    FROM DISK = N'C:\SQL 2012\Backup\ContosoRetailDW.bak'
    WITH MOVE N'ContosoRetailDW2.0' TO N'D:\SQL 2012\Data\ContosoRetailDW.mdf',
         MOVE N'ContosoRetailDW2.0_log' TO N'C:\SQL 2012\Log\ContosoRetailDW.ldf',
         STATS = 5;
GO

USE ContosoRetailDW;
GO

-- Clustered index is tied to primary key, so we have to drop that first
ALTER TABLE dbo.FactOnlineSales
DROP CONSTRAINT PK_FactOnlineSales_SalesKey;

-- Now create a clustered index on the desired column
CREATE CLUSTERED INDEX ix_FactOnlineSales_ProductKey
ON dbo.FactOnlineSales(ProductKey);

-- Recreate the PRIMARY KEY constraint, now using a nonclustered supporting index
ALTER TABLE dbo.FactOnlineSales
ADD CONSTRAINT PK_FactOnlineSales_SalesKey
    PRIMARY KEY (OnlineSalesKey);

-- Then recreate the nonclustered columnstore index without parallelism
CREATE NONCLUSTERED COLUMNSTORE INDEX NCI_FactOnlineSales
ON dbo.FactOnlineSales
   (OnlineSalesKey, DateKey, StoreKey, ProductKey, PromotionKey, CurrencyKey,
    CustomerKey, SalesOrderNumber, SalesOrderLineNumber, SalesQuantity, SalesAmount,
    ReturnQuantity, ReturnAmount, DiscountQuantity, DiscountAmount, TotalCost,
    UnitCost, UnitPrice, ETLLoadID, LoadDate, UpdateDate)
WITH (MAXDOP = 1);
GO
